
#ifndef INC_INA238_H_
#define INC_INA238_H_
#include <stdint.h>
#include "main.h"

#define INA238_BASE_ADDRESS 0b1000000

typedef struct {
	uint8_t dev_address;

	uint8_t rst:1;
	uint8_t adcrange:1;
	uint8_t convdly;
	uint8_t adc_mode:4;
	uint8_t adc_vbusct:3;
	uint8_t adc_vshct:3;
	uint8_t adc_vtct:3;
	uint8_t adc_avg:3;

	uint16_t shunt_calibration;

} ina238_config_t;

typedef struct {
    I2C_HandleTypeDef *i2c;
    uint8_t address;
    union {
    	uint8_t v8[4];
    	uint16_t v16[2];
    	uint32_t v32;
    };
} ina238_handle_t;

void ina238_get_default_config(ina238_config_t *default_config, uint8_t device_address);

HAL_StatusTypeDef ina238_init(ina238_handle_t *ina238, I2C_HandleTypeDef *hi2c, ina238_config_t *config);

HAL_StatusTypeDef ina238_set_configuration(ina238_handle_t *ina238, uint16_t config_value );
HAL_StatusTypeDef ina238_set_adc_configuration(ina238_handle_t *ina238, uint16_t config_value );
HAL_StatusTypeDef ina238_set_shunt_calibration(ina238_handle_t *ina238, uint16_t calibration_value );

HAL_StatusTypeDef ina238_set_shunt_over_threshold(ina238_handle_t *ina238, uint16_t value);
HAL_StatusTypeDef ina238_set_shunt_under_threshold(ina238_handle_t *ina238, uint16_t value);
HAL_StatusTypeDef ina238_set_bus_over_threshold(ina238_handle_t *ina238, uint16_t value);
HAL_StatusTypeDef ina238_set_bus_under_threshold(ina238_handle_t *ina238, uint16_t value);
HAL_StatusTypeDef ina238_set_temperature_threashold(ina238_handle_t *ina238, uint16_t value);
HAL_StatusTypeDef ina238_set_power_limit_threshold(ina238_handle_t *ina238, uint16_t value);

HAL_StatusTypeDef ina238_get_configuration(ina238_handle_t *ina238);
HAL_StatusTypeDef ina238_get_adc_configuration(ina238_handle_t *ina238);
HAL_StatusTypeDef ina238_get_shunt_calibration(ina238_handle_t *ina238);

HAL_StatusTypeDef ina238_get_shunt_voltage_measurement(ina238_handle_t *ina238);
HAL_StatusTypeDef ina238_get_bus_voltage_measurement(ina238_handle_t *ina238);
HAL_StatusTypeDef ina238_get_temperature_measurement(ina238_handle_t *ina238);
HAL_StatusTypeDef ina238_get_current_result(ina238_handle_t *ina238);
HAL_StatusTypeDef ina238_get_power_result(ina238_handle_t *ina238);
HAL_StatusTypeDef ina238_get_diagnostics(ina238_handle_t *ina238);

HAL_StatusTypeDef ina238_get_shunt_over_threshold(ina238_handle_t *ina238);
HAL_StatusTypeDef ina238_get_shunt_under_threshold(ina238_handle_t *ina238);
HAL_StatusTypeDef ina238_get_bus_over_threshold(ina238_handle_t *ina238);
HAL_StatusTypeDef ina238_get_bus_under_threshold(ina238_handle_t *ina238);
HAL_StatusTypeDef ina238_get_temperature_threashold(ina238_handle_t *ina238);
HAL_StatusTypeDef ina238_get_power_limit_threshold(ina238_handle_t *ina238);

HAL_StatusTypeDef ina238_get_manufacturer_id(ina238_handle_t *ina238);
HAL_StatusTypeDef ina238_get_device_id(ina238_handle_t *ina238);


#endif /* INC_INA238_H_ */
