/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.h
  * @brief          : Header for main.c file.
  *                   This file contains the common defines of the application.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2025 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32h5xx_hal.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "commands.h"
#include "ina238.h"
#include "max14906.h"
#include "mcp4725.h"
/* USER CODE END Includes */

/* Exported types ------------------------------------------------------------*/
/* USER CODE BEGIN ET */

/* USER CODE END ET */

/* Exported constants --------------------------------------------------------*/
/* USER CODE BEGIN EC */

/* USER CODE END EC */

/* Exported macro ------------------------------------------------------------*/
/* USER CODE BEGIN EM */

/* USER CODE END EM */

void HAL_TIM_MspPostInit(TIM_HandleTypeDef *htim);

/* Exported functions prototypes ---------------------------------------------*/
void Error_Handler(void);

/* USER CODE BEGIN EFP */
void increment(int pin);

/* USER CODE END EFP */

/* Private defines -----------------------------------------------------------*/
#define SPICS_DA_Pin GPIO_PIN_0
#define SPICS_DA_GPIO_Port GPIOC
#define SYNCH_DA_Pin GPIO_PIN_1
#define SYNCH_DA_GPIO_Port GPIOC
#define ENABLE_DA_Pin GPIO_PIN_2
#define ENABLE_DA_GPIO_Port GPIOC
#define SYNCH_DS_Pin GPIO_PIN_3
#define SYNCH_DS_GPIO_Port GPIOC
#define M_DA1_Pin GPIO_PIN_0
#define M_DA1_GPIO_Port GPIOA
#define M_DA2_Pin GPIO_PIN_1
#define M_DA2_GPIO_Port GPIOA
#define M_DA3_Pin GPIO_PIN_2
#define M_DA3_GPIO_Port GPIOA
#define DS1_Pin GPIO_PIN_3
#define DS1_GPIO_Port GPIOA
#define DS2_Pin GPIO_PIN_4
#define DS2_GPIO_Port GPIOA
#define DS3_Pin GPIO_PIN_5
#define DS3_GPIO_Port GPIOA
#define COMPARTMENT_Pin GPIO_PIN_6
#define COMPARTMENT_GPIO_Port GPIOA
#define GAS_ALARM_Pin GPIO_PIN_7
#define GAS_ALARM_GPIO_Port GPIOA
#define ENABLE_DS_Pin GPIO_PIN_4
#define ENABLE_DS_GPIO_Port GPIOC
#define SPICS_DS_Pin GPIO_PIN_5
#define SPICS_DS_GPIO_Port GPIOC
#define HU_Pin GPIO_PIN_0
#define HU_GPIO_Port GPIOB
#define HV_Pin GPIO_PIN_1
#define HV_GPIO_Port GPIOB
#define FR_STM_Pin GPIO_PIN_2
#define FR_STM_GPIO_Port GPIOB
#define READY_Pin GPIO_PIN_6
#define READY_GPIO_Port GPIOC
#define FAULT_Pin GPIO_PIN_7
#define FAULT_GPIO_Port GPIOC
#define FRSV_FAULT_Pin GPIO_PIN_8
#define FRSV_FAULT_GPIO_Port GPIOC
#define PWR_ALERT_Pin GPIO_PIN_9
#define PWR_ALERT_GPIO_Port GPIOC
#define RCMP_STM_Pin GPIO_PIN_8
#define RCMP_STM_GPIO_Port GPIOA
#define OUT1_Pin GPIO_PIN_11
#define OUT1_GPIO_Port GPIOA
#define OUT2_Pin GPIO_PIN_12
#define OUT2_GPIO_Port GPIOA
#define HOME_Pin GPIO_PIN_15
#define HOME_GPIO_Port GPIOA
#define CRC_EN_Pin GPIO_PIN_12
#define CRC_EN_GPIO_Port GPIOC
#define OUT3_Pin GPIO_PIN_2
#define OUT3_GPIO_Port GPIOD
#define HW_Pin GPIO_PIN_4
#define HW_GPIO_Port GPIOB
#define OUT4_Pin GPIO_PIN_5
#define OUT4_GPIO_Port GPIOB

/* USER CODE BEGIN Private defines */

/* USER CODE END Private defines */

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */
