
#ifndef MAX14906_H_
#define MAX14906_H_

#include <stdint.h>
#include "main.h"

#ifdef DEBUG
#define MAX_DBG(...) printf(__VA_ARGS__)
#else
#define MAX_DBG(...)
#endif

#define MAX14906_DEFAULT_ADDRESS 0x00

#define MAX14906_REG_SETOUT 0x00
#define MAX14906_REG_SETLED 0x01
#define MAX14906_REG_DOILEVEL 0x02
#define MAX14906_REG_INTERRUPT 0x03
#define MAX14906_REG_OVRLDCHF 0x04
#define MAX14906_REG_OPNWIRCHF 0x05
#define MAX14906_REG_SHTVDDCHF 0x06
#define MAX14906_REG_GLOBALERR 0x07
#define MAX14906_REG_OPNWREN 0x08
#define MAX14906_REG_CHTVDDEN 0x09
#define MAX14906_REG_CONFIG1 0x0A
#define MAX14906_REG_CONFIG2 0x0B
#define MAX14906_REG_CONFIGDI 0x0C
#define MAX14906_REG_CONFIGDO 0x0D
#define MAX14906_REG_CURLIM 0x0E
#define MAX14906_REG_MASK 0x0F

typedef struct {
    SPI_HandleTypeDef *spiHandle;
    GPIO_TypeDef *cs_port;
    uint16_t cs_pin;
    uint8_t addr;
} max14906_handle_t;

HAL_StatusTypeDef max14906_init(max14906_handle_t *max14906, SPI_HandleTypeDef *hspi, GPIO_TypeDef *cs_port, uint16_t cs_pin);
HAL_StatusTypeDef max14906_read(max14906_handle_t *max14906, uint8_t reg, uint16_t *output);
HAL_StatusTypeDef max14906_write(max14906_handle_t *max14906, uint8_t reg, uint8_t value);

#endif /* MAX14906_H_ */
