
#ifndef INC_mcp4725_H_
#define INC_mcp4725_H_
#include <stdint.h>
#include "main.h"

#define MCP4725_BASE_ADDRESS 0b1100000

typedef struct {
    I2C_HandleTypeDef *i2c;
    uint8_t address;
    union {
    	uint8_t v8[4];
    	uint16_t v16[2];
    	uint32_t v32;
    };
} mcp4725_handle_t;

HAL_StatusTypeDef mcp4725_init(mcp4725_handle_t *mcp4725, uint8_t address, I2C_HandleTypeDef *i2c);

HAL_StatusTypeDef mcp4725_set_output(mcp4725_handle_t *mcp4725, uint16_t value);


#endif /* INC_mcp4725_H_ */
