#ifndef PID_v1_h
#define PID_v1_h

#include <stdbool.h>

#define PID_AUTO     1
#define PID_MANUAL   0
#define PID_DIRECT   0
#define PID_REVERSE  1
#define PID_P_ON_M   0
#define PID_P_ON_E   1

typedef struct {

    double dispKp;	// * we'll hold on to the tuning parameters in user-entered
    double dispKi;				//   format for display purposes
    double dispKd;				//

    double kp;                  // * (P)roportional Tuning Parameter
    double ki;                  // * (I)ntegral Tuning Parameter
    double kd;                  // * (D)erivative Tuning Parameter

    int controller_direction;
    int p_on;

    double *input;    // * Pointers to the Input, Output, and Setpoint variables
    double *output;  //   This creates a hard link between the variables and the
    double *setpoint; //   PID, freeing the user from having to constantly tell us
                      //   what these values are.  with pointers we'll just know.

    uint32_t last_time;
    double output_sum;
    double last_input;

    uint32_t sample_time;
    double out_min, out_max;
    bool in_auto;
    bool p_on_e;
} pid_t;


bool pid_compute(pid_t *instance);
void pid_initialize(pid_t *instance, double *input, double *output, double *setpoint, double p, double i, double d, int p_on, int controller_direction);

void pid_set_mode(pid_t *instance, int mode);
void pid_set_output_limits(pid_t *instance, double min, double max);
void pid_set_tunings(pid_t *instance, double kp, double ki, double kd, int p_on);

#endif
