#include "ina238.h"

HAL_StatusTypeDef ina238_read(ina238_handle_t *h, uint8_t reg, uint8_t size) {

	HAL_StatusTypeDef status = HAL_I2C_Mem_Read(h->i2c, h->address | 1, reg, 1,	h->v8, size, 5000);
	return status;
}

HAL_StatusTypeDef ina238_write(ina238_handle_t *h, uint8_t reg, uint16_t value) {
	HAL_StatusTypeDef status = HAL_I2C_Mem_Write(h->i2c, h->address, reg, 1, (uint8_t*) &value, 2, 5000);
	return status;
}

HAL_StatusTypeDef ina238_init(ina238_handle_t *h, I2C_HandleTypeDef *hi2c, ina238_config_t *c) {
	h->address = ((c->dev_address & 0x0f) | INA238_BASE_ADDRESS) << 1;
	h->i2c = hi2c;
	uint16_t config_value = (c->rst << 15) | (c->convdly << 6) | (c->adcrange << 4);
	uint16_t adc_config_value = (c->adc_mode << 12) | (c->adc_vbusct << 9) | (c->adc_vshct << 6) | (c->adc_vtct << 3) | c->adc_avg;
	HAL_StatusTypeDef s;
	if ((s = ina238_write(h, 0, config_value)) == HAL_OK) {
		if ((s = ina238_write(h, 1, adc_config_value)) == HAL_OK) {
			if ((s = ina238_write(h, 2, c->shunt_calibration & 0x7FFF)) == HAL_OK) {
				return HAL_OK;
			}
		}
	}
	return s;
}

void ina238_get_default_config(ina238_config_t *c, uint8_t device_address) {
	c->dev_address = device_address;
	c->rst = 0;
	c->convdly = 0;
	c->adcrange = 0;
	c->adc_mode = 0b1111;
	c->adc_vbusct = 0b101;
	c->adc_vshct = 0b101;
	c->adc_vtct = 0b101;
	c->adc_avg = 0b000;
}

HAL_StatusTypeDef ina238_set_shunt_over_threshold(ina238_handle_t *h, uint16_t value) {
	return ina238_write(h, 0x0c, value);
}

HAL_StatusTypeDef ina238_set_shunt_under_threshold(ina238_handle_t *h, uint16_t value) {
	return ina238_write(h, 0x0d, value);
}

HAL_StatusTypeDef ina238_set_bus_over_threshold(ina238_handle_t *h, uint16_t value) {
	return ina238_write(h, 0x0e, value);
}

HAL_StatusTypeDef ina238_set_bus_under_threshold(ina238_handle_t *h, uint16_t value) {
	return ina238_write(h, 0x0f, value);
}

HAL_StatusTypeDef ina238_set_temperature_threashold(ina238_handle_t *h, uint16_t value) {
	return ina238_write(h, 0x10, value);
}

HAL_StatusTypeDef ina238_set_power_limit_threshold(ina238_handle_t *h, uint16_t value) {
	return ina238_write(h, 0x11, value);
}

HAL_StatusTypeDef ina238_get_configuration(ina238_handle_t *h) {
	return ina238_read(h, 0x00, 2 );
}

HAL_StatusTypeDef ina238_get_adc_configuration(ina238_handle_t *h) {
	return ina238_read(h, 0x01, 2 );
}

HAL_StatusTypeDef ina238_get_shunt_calibration(ina238_handle_t *h) {
	return ina238_read(h, 0x02, 2 );
}

HAL_StatusTypeDef ina238_get_shunt_voltage_measurement(ina238_handle_t *h) {
	return ina238_read(h, 0x04, 2 );
}

HAL_StatusTypeDef ina238_get_bus_voltage_measurement(ina238_handle_t *h) {
	return ina238_read(h, 0x05, 2 );
}

HAL_StatusTypeDef ina238_get_temperature_measurement(ina238_handle_t *h) {
	return ina238_read(h, 0x06, 2 );
}

HAL_StatusTypeDef ina238_get_current_result(ina238_handle_t *h) {
	return ina238_read(h, 0x07, 2 );
}

HAL_StatusTypeDef ina238_get_power_result(ina238_handle_t *h) {
	return ina238_read(h, 0x08, 3 );
}

HAL_StatusTypeDef ina238_get_diagnostics(ina238_handle_t *h) {
	return ina238_read(h, 0x0b, 2 );
}

HAL_StatusTypeDef ina238_get_shunt_over_threshold(ina238_handle_t *h) {
	return ina238_read(h, 0x0c, 2 );
}

HAL_StatusTypeDef ina238_get_shunt_under_threshold(ina238_handle_t *h) {
	return ina238_read(h, 0x0d, 2 );
}

HAL_StatusTypeDef ina238_get_bus_over_threshold(ina238_handle_t *h) {
	return ina238_read(h, 0x0e, 2 );
}

HAL_StatusTypeDef ina238_get_bus_under_threshold(ina238_handle_t *h) {
	return ina238_read(h, 0x0f, 2 );
}

HAL_StatusTypeDef ina238_get_temperature_threashold(ina238_handle_t *h) {
	return ina238_read(h, 0x10, 2 );
}

HAL_StatusTypeDef ina238_get_power_limit_threshold(ina238_handle_t *h) {
	return ina238_read(h, 0x11, 2 );
}

HAL_StatusTypeDef ina238_get_manufacturer_id(ina238_handle_t *h) {
	return ina238_read(h, 0x3e, 2 );
}

HAL_StatusTypeDef ina238_get_device_id(ina238_handle_t *h) {
	return ina238_read(h, 0x3f, 2 );
}

