#include <stdio.h>
#include "main.h"



// Private functions

static inline void cs_on(max14906_handle_t *max14906) {
    HAL_GPIO_WritePin(max14906->cs_port, max14906->cs_pin, GPIO_PIN_RESET);
}

static inline void cs_off(max14906_handle_t *max14906) {
    HAL_GPIO_WritePin(max14906->cs_port, max14906->cs_pin, GPIO_PIN_SET);
}

HAL_StatusTypeDef max14906_read(max14906_handle_t *max14906, uint8_t reg, uint16_t *output) {

    uint8_t txbuf[2] = {0}, rxbuf[2] = {0};
    txbuf[0] = (max14906->addr << 6) + (reg << 1);
    cs_on(max14906);
    HAL_StatusTypeDef res = HAL_SPI_TransmitReceive(max14906->spiHandle, (uint8_t *)&txbuf, (uint8_t *)&rxbuf, 2, HAL_MAX_DELAY);
    cs_off(max14906);
    *output = rxbuf[0] << 8 | rxbuf[1];
    return res;
}

HAL_StatusTypeDef max14906_write(max14906_handle_t *max14906, uint8_t reg, uint8_t value) {

    uint8_t txbuf[2] = {0}, rxbuf[2] = {0};
    txbuf[0] = (max14906->addr << 6) | (reg << 1) | 1;
    txbuf[1] = value;
    cs_on(max14906);
    HAL_StatusTypeDef res = HAL_SPI_TransmitReceive(max14906->spiHandle, (uint8_t *)&txbuf, (uint8_t *)&rxbuf, 2, HAL_MAX_DELAY);
    cs_off(max14906);
    return res;
}

HAL_StatusTypeDef max14906_init(max14906_handle_t *max14906, SPI_HandleTypeDef *hspi, GPIO_TypeDef *cs_port, uint16_t cs_pin) {
    MAX_DBG("MAX14906 Init\n");
    max14906->spiHandle = hspi;
    max14906->cs_port = cs_port;
    max14906->cs_pin = cs_pin;
    max14906->addr = MAX14906_DEFAULT_ADDRESS;
    cs_off(max14906);
    return HAL_OK;
}
