
#include "mcp4725.h"

HAL_StatusTypeDef mcp4725_init(mcp4725_handle_t *mcp4725, uint8_t address, I2C_HandleTypeDef *i2c) {
    mcp4725->i2c = i2c;
    mcp4725->address = address << 1;
    return mcp4725_set_output(mcp4725, 0);
}

HAL_StatusTypeDef mcp4725_set_output(mcp4725_handle_t *mcp4725, uint16_t value) {
	uint8_t buffer[4];
	buffer[0] = (uint8_t) (value >> 8);
	buffer[1] = (uint8_t) (value & 0xFF);
    return HAL_I2C_Master_Transmit(mcp4725->i2c, mcp4725->address, buffer, 2, 200); // FastMode write.
}
